/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.mx.core.Container;
import intrinsic.mx.core.UIComponent;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class TabItem extends Item {
	TabFolder parent;
	Control control;
	String toolTipText;

public TabItem (TabFolder parent, int style) {
	super (parent, style);
	this.parent = parent;
	parent.createItem (this, parent.getItemCount ());
}

public TabItem (TabFolder parent, int style, int index) {
	super (parent, style);
	this.parent = parent;
	parent.createItem (this, index);
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

void createHandle () {
	intrinsic.mx.containers.Canvas widget = new intrinsic.mx.containers.Canvas();
	if (widget == null) error(SWT.ERROR_NO_HANDLES);
	object = widget;
}

void destroyWidget() {
	parent.removeItem (this);
	super.destroyWidget();
}

public Control getControl () {
	checkWidget();
	return control;
}

public TabFolder getParent () {
	checkWidget();
	return parent;
}

public String getToolTipText () {
	checkWidget();
	return toolTipText;
}

void releaseHandle () {
	super.releaseHandle ();
	object = null;
	parent = null;
}

void releaseParent () {
	super.releaseParent ();
	int index = parent.indexOf (this);
	if (index == parent.getSelectionIndex ()) {
		if (control != null) control.setVisible (false);
	}
}

void releaseWidget () {
	super.releaseWidget ();
	control = null;
}

public void setControl (Control control) {
	checkWidget();
	if (control != null) {
		if (control.isDisposed()) error (SWT.ERROR_INVALID_ARGUMENT);
		if (control.parent != parent) error (SWT.ERROR_INVALID_PARENT);
	}
	if (this.control != null && this.control.isDisposed ()) {
		this.control = null;
	}
	Control oldControl = this.control, newControl = control;
	this.control = control;
	if (newControl != null) {
		UIComponent widget = newControl.topComponent();
		widget.percentWidth = widget.percentHeight = 100;
		object.addChild(widget);
		newControl.setVisible (true);
	}
	if (oldControl != null) {
		object.removeChild(oldControl.topComponent());
		//TODO remove percentWidth/Height
		oldControl.setVisible (false);
	}
}

public void setImage (Image image) {
	checkWidget();
	super.setImage (image);
	((Container)object).icon = image != null ? SWTBitmapAsset.getClazz() : null;
}

public void setText (String string) {
	checkWidget();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (string.equals (text)) return;
	super.setText (string);
	((intrinsic.mx.containers.Canvas)object).label = fixMnemonic (string);
}

public void setToolTipText (String string) {
	checkWidget();
	toolTipText = string;
	//TODO should set tabBar instead
	object.toolTip = string;
}

}
